/*
 * Decompiled with CFR 0.152.
 */
package scientific;

import common.util.Calculator;
import scientific.Operator;

public final class UnaryOperator
extends Operator {
    public static final int SQUARE_ROOT_ID = 1;
    public static final int SIN_ID = 2;
    public static final int COS_ID = 3;
    public static final int TAN_ID = 4;
    public static final int ASIN_ID = 5;
    public static final int ACOS_ID = 6;
    public static final int ATAN_ID = 7;
    public static final int FACTORIAL_ID = 8;
    public static final int LOG_ID = 9;
    public static final int LN_ID = 10;

    public UnaryOperator(int id) {
        super(id);
        switch (id) {
            case 1: {
                this.value = "\u221a";
                break;
            }
            case 2: {
                this.value = "SIN";
                break;
            }
            case 3: {
                this.value = "COS";
                break;
            }
            case 4: {
                this.value = "TAN";
                break;
            }
            case 5: {
                this.value = "ASIN";
                break;
            }
            case 6: {
                this.value = "ACOS";
                break;
            }
            case 7: {
                this.value = "ATAN";
                break;
            }
            case 8: {
                this.value = "!";
                break;
            }
            case 9: {
                this.value = "LOG";
                break;
            }
            case 10: {
                this.value = "LN";
            }
        }
    }

    public double calculate(boolean isDegrees) {
        switch (this.id) {
            case 1: {
                return Calculator.getInstance().sqrt(this.leftChild.calculate(isDegrees));
            }
            case 2: {
                return Calculator.getInstance().sin(this.leftChild(isDegrees));
            }
            case 3: {
                return Calculator.getInstance().cos(this.leftChild(isDegrees));
            }
            case 4: {
                return Calculator.getInstance().tan(this.leftChild(isDegrees));
            }
            case 5: {
                double result = Calculator.getInstance().asin(this.leftChild.calculate(isDegrees));
                if (isDegrees) {
                    return Math.toDegrees(result);
                }
                return result;
            }
            case 6: {
                double result = Calculator.getInstance().acos(this.leftChild.calculate(isDegrees));
                if (isDegrees) {
                    return Math.toDegrees(result);
                }
                return result;
            }
            case 7: {
                double result = Calculator.getInstance().atan(this.leftChild.calculate(isDegrees));
                if (isDegrees) {
                    return Math.toDegrees(result);
                }
                return result;
            }
            case 8: {
                return Calculator.getInstance().factorial(this.leftChild.calculate(isDegrees));
            }
            case 9: {
                return Calculator.getInstance().log(this.leftChild.calculate(isDegrees));
            }
            case 10: {
                return Calculator.getInstance().ln(this.leftChild.calculate(isDegrees));
            }
        }
        throw new IllegalStateException();
    }

    private double leftChild(boolean isDegrees) {
        if (isDegrees) {
            return Math.toRadians(this.leftChild.calculate(isDegrees));
        }
        return this.leftChild.calculate(isDegrees);
    }
}

